package mcmas.core.examples;

import mcmas.core.MCM;
import mcmas.core.MCMCommandQueue;
import mcmas.core.MCMCommandQueueProperty;
import mcmas.core.MCMContext;
import mcmas.core.MCMEvent;
import mcmas.core.MCMKernel;
import mcmas.core.MCMMem;
import mcmas.core.MCMProgram;

public class MCMTest {
	
	public static final String kernelCode =
			"kernel void longComputation(int a, global int * res) {     \n" +
			"    int tmp = 0;                                           \n" +
			"    for (int i = 0; i < 100 * a; i++) {                          \n" +
			"        tmp += sqrt((float) i);                                    \n" +
			"    }                                                      \n" +
			"    int i = get_global_id(0);                       \n" +
			"    res[i] += tmp;                                         \n" +
			"}";
	
	public static void main(String[] args) {
		MCMContext context = new MCMContext();
		MCMCommandQueue queue = context.createCommandQueue(MCMCommandQueueProperty.ENABLE_PROFILING, MCMCommandQueueProperty.ENABLE_OOO_MODE);
		MCMProgram program = context.createProgram(kernelCode);
		
		MCMKernel kernel1 = program.createKernel("longComputation");
		MCMMem output1 = context.newBuffer().Size(200000000, MCM.INT).b();
		kernel1.setArguments(10000, output1);
		
		MCMKernel kernel2 = program.createKernel("longComputation");
		MCMMem output2 = context.newBuffer().Size(200000000, MCM.INT).b();
		kernel2.setArguments(100, output1);
		
		MCMEvent kernel1Event = queue.enqueue1DKernel(kernel1, 1024, 1);
		MCMEvent kernel2Event = queue.enqueue1DKernel(kernel2, 1024, 1);
		MCMEvent.waitFor(kernel2Event);
		MCMEvent.waitFor(kernel1Event);
		
		output1.release();
		kernel1.release();
		
		output2.release();
		kernel2.release();
		
		program.release();
		queue.release();
		context.release();
		
		System.out.println("K1 Wait : " + kernel1Event.getWaitDuration());
		System.out.println("K1 Time : " + kernel1Event.getExecutionDuration());
		System.out.println("K2 Wait : " + kernel2Event.getWaitDuration());
		System.out.println("K2 Time : " + kernel2Event.getExecutionDuration());
	}
}
