package mcmas.core.examples;

import java.util.Arrays;

import mcmas.core.MCM;
import mcmas.core.MCMCommandQueue;
import mcmas.core.MCMCommandQueueProperty;
import mcmas.core.MCMContext;
import mcmas.core.MCMEvent;
import mcmas.core.MCMKernel;
import mcmas.core.MCMMem;
import mcmas.core.MCMProgram;

import org.jocl.Pointer;
import org.jocl.Sizeof;


public class MCMSimple {
	
	public static final int SIZE = 512;
	
	public static final String simpleKernel = "" +
		"int add(int a, int b) {                             \n" +
		"    return a + 3 * b;                               \n" +
		"}                                                   \n" +
		"                                                    \n" +
		"kernel void simple(global int *c) {                 \n" +
		"    int i = get_global_id(0);                       \n" +
		"    c[i]  = add(i, i);                              \n" +
		"}";
	
	public static void main(String[] args) {
		MCMContext context = new MCMContext();
		MCMCommandQueue queue = context.createCommandQueue(MCMCommandQueueProperty.ENABLE_PROFILING);
		MCMProgram program = context.createProgram(simpleKernel);
		MCMKernel kernel = program.createKernel("simple");
		
		MCMMem outputBuffer = context.newBuffer().Size(SIZE, MCM.INT).b();
		//context.createBuffer(SIZE, OCL.INT, OCL.MEM_RW);
		
		kernel.setArguments(outputBuffer);
		MCMEvent kernelEvent = queue.enqueue1DKernel(kernel, SIZE, 1);
		MCMEvent.waitFor(kernelEvent);
		
		int[] output = new int[SIZE];
		queue.blockingReadBuffer(outputBuffer, Pointer.to(output), 0, SIZE * Sizeof.cl_int);
		
		outputBuffer.release();
		kernel.release();
		program.release();
		queue.release();
		context.release();
		
		System.out.println(Arrays.toString(output));
		System.out.println("Time : " + kernelEvent.getExecutionDuration());
		//System.out.println("START : " + kernelEvent.getProfilingInfo(OCLProfilingInfo.COMMAND_START));
		//System.out.println("END   : " + kernelEvent.getProfilingInfo(OCLProfilingInfo.COMMAND_END));
	}

}
