package mcmas.core.examples;
import java.util.Arrays;

import org.jocl.struct.ArrayLength;
import org.jocl.struct.Struct;


public class MCMGrid extends Struct {
	
	public int width;
	public int height;
	
	@ArrayLength({12, 10})
	public int[][] data;
	
	public MCMGrid(int width, int height) {
		this.width = width;
		this.height = height;
		this.data = new int[height][width];
	}
	
	public static String toOpenCL() {
		return "typedef struct            \n" +
        	   "{                         \n" +
               "    int width;            \n" +
               "    int height;           \n" +
               "    int** data;           \n" +
               "} Grid;                   \n";
	}
	
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		for (int[] line : data) {
			buffer.append(Arrays.toString(line));
			buffer.append('\n');
		}
		return new String(buffer);
	}

}
