package mcmas.core;

import org.jocl.Pointer;
import org.jocl.Sizeof;

public class MCMProperties {
	
	private final MCMRequestable requestable;
	
	public MCMProperties(MCMRequestable requestable) {
		this.requestable = requestable;
	}
	
	public int getInt(int param) {
		int[] result = new int[1];
		requestable.getInfo(param ,Sizeof.cl_int, Pointer.to(result), null);
		return result[0];
	}
	
	public long getLong(int param) {
		long[] result = new long[1];
		requestable.getInfo(param ,Sizeof.cl_long, Pointer.to(result), null);
		return result[0];
	}
	
	public String getString(int param) {
		long [] size = new long[1];
		requestable.getInfo(param, 0, null, size);
		
		byte [] value = new byte[(int) (size[0])];
		requestable.getInfo(param, size[0], Pointer.to(value), size);
		
		return new String(value);
	}
}
