package mcmas.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MCMProgramOptions {
	
	private HashMap<String, Object> definitions;
	private List<String> options;
	
	public MCMProgramOptions(String... options) {
		this.definitions = new HashMap<String, Object>();
		this.options = Arrays.asList(options);
	}
	
	public void define(String key) {
		this.definitions.put(key, null);
	}
	
	public void define(String key, Object value) {
		this.definitions.put(key, value);
	}
	
	public void undefine(String key) {
		this.definitions.remove(key);
	}
	
	public void addOption(String option) {
		this.options.add(option);
	}
	
	public void removeOption(String option) {
		this.options.remove(option);
	}
	
	public void clear() {
		this.definitions.clear();
		this.options.clear();
	}
	
	public HashMap<String, Object> getDefinitions() {
		return this.definitions;
	}
	
	public List<String> getOptions() {
		return this.options;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		
		for (String option: options) {
			builder.append(option);
			builder.append(' ');
		}
		
		for (String key : definitions.keySet()) {
			Object value = definitions.get(key);
			if (value == null) {
				builder.append("-D");
				builder.append(key);
				builder.append(' ');
			} else {
				builder.append("-D");
				builder.append(key);
				builder.append("=");
				builder.append(value);
				builder.append(' ');
			}
		}
		
		return builder.toString();
	}

}
