package mcmas.core;

import mcmas.utils.Objects7;

import org.jocl.CL;
import org.jocl.cl_program;


public class MCMProgram extends MCMObject {
	
	private final MCMContext context;
	private final cl_program program;
	
	public MCMProgram(MCMContext context, String source, String... options) {
		context = Objects7.requireNonNull(context, "Can't create a program using a null context");
		MCMProgramOptions o = new MCMProgramOptions(options);
		
		this.program = MCMHelpers.createProgram(context.getContext(), source, o.toString());
		this.context = context;
	}
	
	public MCMProgram(MCMContext context, String source,  MCMMemoryContext memoryContext, String... options) {
		this(context, source, options);
		
		this.setMemoryContext(memoryContext);
	}
	
	public cl_program getProgram() {
		return program;
	}
	
	public MCMContext getContext() {
		return context;
	}
	
	public MCMKernel createKernel(String name) {
		MCMKernel k = new MCMKernel(this, name);
		this.register(k);
		return k;
	}
	
	@Override
	protected void releaseImpl() {
		CL.clReleaseProgram(program);
	}
	
}
