package mcmas.core;

public abstract class MCMObject {
	
	private boolean released = false;
	private MCMMemoryContext memoryContext;
	
	public void setMemoryContext(MCMMemoryContext memoryContext) {
		this.memoryContext = memoryContext;
	}
	
	public MCMMemoryContext getMemoryContext() {
		return memoryContext;
	}
	
	public void register(MCMObject o) {
		if (memoryContext != null) {
			memoryContext.add(o);
			o.setMemoryContext(memoryContext);
		}
	}
	
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		if (! released) {
			release();
		}
	}
	
	public final void release() {
		this.released = true;
		releaseImpl();
	}
	
	protected abstract void releaseImpl();
	
}
