package mcmas.core;

import org.jocl.CL;

/**
 * Represents all the possible states for a MCMEvent
 */
public enum MCMEventStatus {
	QUEUED   	(CL.CL_QUEUED),
	SUBMITTED	(CL.CL_SUBMITTED),
	RUNNING		(CL.CL_RUNNING),
	COMPLETE	(CL.CL_COMPLETE);
	
	public final int value;
	
	private MCMEventStatus(int value) {
		this.value = value;
	}
	
	/**
	 * Create a MCMEventStatus objet from a native value
	 * @param value value to wrap
	 * @return a new MCMEventStatus
	 */
	public static MCMEventStatus wrap(int value) {
		for (MCMEventStatus status : MCMEventStatus.values()) {
			if (status.value == value) return status;
		}
		return null;
	}

}
