package mcmas.core;

public class MCMChrono {
	
	private String tag;
	private long start;
	private long stop;
	
	public MCMChrono(String tag) {
		this.tag = tag;
	}
	
	public MCMChrono start() {
		this.start = System.nanoTime();
		return this;
	}
	
	public MCMChrono start(String tag) {
		this.tag = tag;
		return this.start();
	}
	
	public MCMChrono stop() {
		this.stop = System.nanoTime();
		return this;
	}
	
	public double getValue() {
		return ((stop > start ? stop - start : 0) / 1000) / 1000.0;
	}
	
	public String toString() {
		return "[ " + tag + " ] Time (ms) : " + getValue();
	}
	
}
