package mcmas.core;

import org.jocl.struct.SizeofStruct;

public class MCM {
	
	/**
	 * OCL Native data types
	 */
	public static final MCMType INT = MCMType.INT;
	public static final MCMType LONG = MCMType.LONG;
	public static final MCMType CHAR = MCMType.CHAR;
	public static final MCMType MEM = MCMType.MEM;
	public static final MCMType FLOAT = MCMType.FLOAT;
	public static final MCMType DOUBLE = MCMType.DOUBLE;
	
	/**
	 * OCL Memory modes
	 */
	public static final MCMMemFlag MEM_RO = MCMMemFlag.READ_ONLY;
	public static final MCMMemFlag MEM_WO = MCMMemFlag.WRITE_ONLY;
	public static final MCMMemFlag MEM_RW = MCMMemFlag.READ_WRITE;
	
	/**
	 * CommandQueue options
	 */
	public static final MCMCommandQueueProperty OOO_MODE = MCMCommandQueueProperty.ENABLE_OOO_MODE;
	public static final MCMCommandQueueProperty PROFILING = MCMCommandQueueProperty.ENABLE_PROFILING;
	
	/**
	 * OCL versions as integer constants
	 */
	public static final int CL_VERSION_1_0 = 100;
	public static final int CL_VERSION_1_1 = 110;
	public static final int CL_VERSION_1_2 = 120;
	
	/**
	 * Helper for structs
	 * @param a Struct subclass
	 * @return binary size of the C representation of this class
	 */
	public static int sizeof(Class<?> klass) {
		return SizeofStruct.sizeof(klass);
	}
}
