package mcmas.api;

/**
 * This exception is used to report most MCMAS-related error.
 * It inherits from RuntimeException to make any error checking optional :
 * if nobody catch the exception, it will interrupt the program.
 * 
 */
public class MCMASException extends RuntimeException {

	private static final long serialVersionUID = 1L;
	
	public MCMASException(String message) {
		super(message);
	}
	
	public MCMASException(Throwable cause) {
		super(cause);
	}
	
	public MCMASException(String message, Throwable cause) {
		super(message, cause);
	}
	
}
