package mcmas.api;

import mcmas.core.MCMCommandQueue;
import mcmas.core.MCMCommandQueueProperty;
import mcmas.core.MCMContext;

/**
 * A MCMASContext is a class which contains all the environement
 * required to call any high-level MCMAS operation.
 * 
 * It includes, in particular, a low level MCM context
 * and command queue which can be used to call low-level operations.
 *
 */
public class MCMASContext {
	
	private final MCMContext context;
	private final MCMCommandQueue queue;
	
	public MCMASContext(MCMCommandQueueProperty... properties) {
		this.context = new MCMContext();
		this.queue = context.createCommandQueue(properties);
	}
	
	public MCMASContext(ContextType type, MCMCommandQueueProperty... properties) {
		this.context = new MCMContext(type.value);
		this.queue = context.createCommandQueue(properties);
	}
	
	public MCMASContext(MCMContext context, MCMCommandQueue queue) {
		this.context = context;
		this.queue = queue;
	}
	
	/**
	 * Get the MCM context included in this MCMAS context
	 * @return the embedded MCM context
	 */
	public MCMContext getContext() {
		return context;
	}
	
	/**
	 * Get the MCM command queue included in this MCMAS context
	 * @return the embedded MCM command queue
	 */
	public MCMCommandQueue getQueue() {
		return queue;
	}

}
