package mcmas.api;

import mcmas.core.MCMCommandQueueProperty;

/**
 * Class containing most MCMAS-wide shortcuts,
 * to enable use of MPI-like programmation suck as MCMAS.INT
 */
public class MCMAS {
	
	/**
	 * Shortcuts for context types
	 */
	
	public final ContextType CPU = ContextType.CPU;
	public final ContextType GPU = ContextType.GPU;
	
	/**
	 * Shortcuts for execution options
	 */
	
	public final long ENABLE_PROFILING = MCMCommandQueueProperty.ENABLE_PROFILING.getValue();
	public final long ENABLE_OOO_MODE  = MCMCommandQueueProperty.ENABLE_OOO_MODE.getValue();
	
	/**
	 * Shortcuts for MCMAS types.
	 */
	
	public final DataType BYTE = DataType.BYTE;
	public final DataType SHORT = DataType.SHORT;
	public final DataType INT = DataType.INT;
	public final DataType LONG = DataType.LONG;
	public final DataType FLOAT = DataType.FLOAT;
	public final DataType DOUBLE = DataType.DOUBLE;
	
}
