package mcmas.api;

/**
 * Base interface implemented by all MCMAS plugins.
 * This contract ensures that any plugin can be constructed
 * using a "newInstance" function call.
 *
 * @param <T> Specific plugin class to return (used by child classes).
 */
public interface IPlugin<T> {
	
	public T newInstance();
	public T newInstance(MCMASContext context);
	
}
