package mcmas.api;

import org.jocl.CL;

/**
 * MCMAS context type to be obtained.
 * DEFAULT: let MCMAS select a device
 * ACCELERATOR: use accelerators such as Xeon Phi
 * GPU; use GPU devices from NVIDIA, AMD or Intel
 * ALL: use any available OpenCL device
 */
public enum ContextType {
	DEFAULT		(CL.CL_DEVICE_TYPE_DEFAULT),
	ACCELERATOR	(CL.CL_DEVICE_TYPE_ACCELERATOR),
	GPU			(CL.CL_DEVICE_TYPE_GPU),
	CPU			(CL.CL_DEVICE_TYPE_CPU),
	ALL			(CL.CL_DEVICE_TYPE_ALL);
	
	public final long value;
	
	private ContextType(long value) {
		this.value = value;
	}
	
}
