package collembola.model;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;

import javax.imageio.ImageIO;

public class CollemUtils {
	
	public static void savePicture(int[] grid, int width, String prefix, int index) {
		HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
		Random rng = new Random();
		
		final int height = grid.length / width;
		//System.out.println(Arrays.toString(grid));
		BufferedImage img = new BufferedImage(width, height, ColorSpace.TYPE_RGB);
		
		for (int i = 0; i < height; i++) {
			for (int j = 0; j < width; j++) {
				final int id = grid[i * width + j];
				
				if (! colorMap.containsKey(id)) {
					colorMap.put(id, rng.nextInt());
				}
				
				img.setRGB(j, height - 1 - i, colorMap.get(id));
			}
		}
		
		try {
			System.out.println("Writing data/" + prefix + "-" + index + ".png ...");
			ImageIO.write(img, "png", new File("data/" + prefix + "-" + index + ".png"));
		} catch (IOException e) {
			throw new RuntimeException("Error saving picture", e);
		}
		
	}
	
}
