package collembola.model;

import java.util.Arrays;

public class CollemModel {
	
	//private final int width;
	//private final int height;
	//private final int plotsTotal;
	
	//private CollemCell[][] grid;
	private final int [] patchesPopulations;
	private final int [] patchesOwners;
	private final int [] patchesTypes;
	
	private final int [] plotsSurfaces;
	
	private CollemWorld world;
	
	public CollemModel(int height, int width, int nbPlots) {
		//this.grid = new CollemCell[x][y];
		
		//for (int i = 0; i < x; i++) {
		//	for (int j = 0; j < y; j++) {
		//		grid[i][j] = new CollemCell();
		//	}
		//}
		
		this.patchesPopulations = new int[height * width];
		this.patchesOwners = new int[height * width];
		this.patchesTypes = new int[height * width];
		
		this.plotsSurfaces = new int[nbPlots];
		
		this.world = new CollemWorld();
		this.world.height = height;
		this.world.width = width;
		this.world.speciality = 2; // CULTURE
		
		patchesPopulations[1 * width + 7] = 100;
		
		Arrays.fill(patchesPopulations, 0);
		Arrays.fill(patchesOwners, -1);
		Arrays.fill(patchesTypes, -1);
	}
	
	public int getHeight() {
		return world.height;
	}
	
	public int getWidth() {
		return world.width;
	}
	
	/*public CollemCell[][] getGrid() {
		return grid;
	}*/
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		
		for (int i = 0; i < world.height; i++) {
			for (int j = 0; j < world.width; j++) {
				builder.append(String.format("%03d ", patchesOwners[i * world.width + j]));
			}
			
			builder.append('\n');
		}
		
		return builder.toString();
	}
	
	/*public void savePicture() {
		savePicture(0);
	}
	*/
	/*
	public void savePicture(int index) {
		HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
		Random rng = new Random();
		
		BufferedImage img = new BufferedImage(world.width, world.height, ColorSpace.TYPE_RGB);
		
		for (int i = 0; i < world.height; i++) {
			for (int j = 0; j < world.width; j++) {
				final int id = patchesOwners[i * world.width + j];
				
				if (! colorMap.containsKey(id)) {
					colorMap.put(id, rng.nextInt());
				}
				
				img.setRGB(j, world.height - 1 - i, colorMap.get(id));
			}
		}
		
		try {
			ImageIO.write(img, "png", new File("data/output-" + index + ".png"));
		} catch (IOException e) {
			throw new RuntimeException("Error saving picture", e);
		}
		
	}*/
	
	public int getPatchPopulation(int i, int j) {
		return patchesPopulations[i * world.width + j];
	}

	public void setPatchPopulation(int i, int j, int pop) {
		patchesPopulations[i * world.width + j] = pop;
	}
	
	public int getPatchOwner(int i, int j) {
		return patchesOwners[i * world.width + j];
	}
	
	public void setPatchOwner(int i, int j, int owner) {
		patchesOwners[i * world.width + j] = owner;
	}
	
	public int getPatchType(int i, int j) {
		return patchesTypes[i * world.width + j];
	}
	
	
	public void setPatchType(int i, int j, int type) {
		//System.out.println("setPatchType(" + i + "," + j + "," + type + ")");
		patchesTypes[i * world.width + j] = type;
		//System.out.println(patchesTypes[i * world.width + j]);
	}
	
	public int[] getPatchesPopulations() {
		return patchesPopulations;
	}
	
	public int[] getPatchesOwners() {
		return patchesOwners;
	}
	
	public int[] getPatchesTypes() {
		return patchesTypes;
	}
	
	public int[] getPlotsSurfaces() {
		return plotsSurfaces;
	}
	
	public CollemWorld getWorld() {
		return world;
	}

}
