package collembola;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;


public class ImagePanel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	private BufferedImage img;
	
	public ImagePanel(BufferedImage img) {
		this.img = img;
		setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
		//setPreferredSize(new Dimension(500, 500));
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		Graphics2D g2d = (Graphics2D) g;
		
		double xscale = (1.0 * getWidth()) / img.getWidth();
		double yscale = (1.0 * getHeight()) / img.getHeight();
		
		 //g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
         //        RenderingHints.VALUE_ANTIALIAS_ON);
		 
		//g2d.scale(4, 4);
		g2d.scale(xscale, yscale);
		g2d.drawImage(img, 0, 0, null);
	}
	

}
