package collembola;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;

import javax.imageio.ImageIO;

public class CollemBuffer2 {
	
	private final int height;
	private final int width;
	private final int nbPlots;
	
	private BufferedImage image;
	
	public CollemBuffer2(int height, int width, int nbPlots) {
		this.height = height;
		this.width = width;
		this.nbPlots = nbPlots;
		
		this.image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		
		Graphics2D g2d = image.createGraphics();
		Random rng = new Random();
		
		int avgHeight = (int) Math.ceil(height / Math.sqrt(nbPlots));
		int avgWidth  = (int) Math.ceil(width / Math.sqrt(nbPlots));
		
		for (int i = 0; i < nbPlots; i++) {
			float randomX = rng.nextFloat() * height;
			float randomY = rng.nextFloat() * width;
			float h = rng.nextFloat() * 3 * avgHeight;
			float w = rng.nextFloat() * 3 * avgWidth;
			
			//Ellipse2D e2d = new Ellipse2D.Double(randomX - height / 8, randomY - height / 8, height / 4, height / 4);
			Shape sh = new Rectangle2D.Float(randomX - w / 2, randomY - h / 2, w, 2 * h);
			g2d.setColor(new Color(rng.nextInt()));
			g2d.fill(sh);
		}
		
		try {
			ImageIO.write(image, "png", new File("test.png"));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		System.out.println("toto");
		new CollemBuffer2(254, 254, 137);
	}

}
