import mcmas.core.MCMCommandQueue;
import mcmas.core.MCMCommandQueueProperty;
import mcmas.core.MCMContext;
import mcmas.core.MCMDevice;
import mior.model.MiorSimulation;
import mior.model.dist.IMiorDistribution;
import mior.model.dist.LinearDistribution;


public class MiorLauncher2 extends Thread {
	
	private final int nbExecutions;
	private final MCMContext context;
	private final MCMDevice device;
	
	public MiorLauncher2(int nbExecutions, MCMContext context, MCMDevice device) {
		this.nbExecutions = nbExecutions;
		this.context = context;
		this.device = device;
	}
	
	@Override
	public void run() {
		MiorSimulation [] simulations = new MiorSimulation[nbExecutions];
		
		MCMCommandQueue queue = context.createCommandQueue(device,
				MCMCommandQueueProperty.ENABLE_PROFILING,
				MCMCommandQueueProperty.ENABLE_OOO_MODE
		);
		
		IMiorDistribution dist = new LinearDistribution(38, 310, 0.3);
		
		for (int i = 0; i < simulations.length; i++) {
			simulations[i] = new MiorSimulation(38, 310, 100, dist);
		}
		
		for (int i = 0; i < simulations.length; i++) {
			simulations[i].execute(context, queue);
		}
		
		queue.finish();
	}
	
	public static void main(String[] args) {
		final int nbThreads = 10;
		final Thread [] threads = new Thread[nbThreads];
		final MCMContext context = new MCMContext();
		
		int nbDevices = context.getDevices().length;
		
		for (int i = 0; i < nbThreads; i++) {
			threads[i] = new MiorLauncher2(10 , context, context.getDevices()[i % nbDevices]);
		}
		
		for (int i = 0; i < nbThreads; i++) {
			threads[i].start();
		}
		
		for (int i = 0; i < nbThreads; i++) {
			try {
				threads[i].join();
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

}
