kernel void transform(global TYPE *vector, float a, float b)
{
    const int i = get_global_id(0);
    
    TYPE value = (TYPE) (vector[i] * a + b);
    vector[i] = value;
}

kernel void clamped_transform(global TYPE *vector, float a, float b, TYPE min, TYPE max)
{
    const int i = get_global_id(0);
    
    TYPE value = (TYPE) (vector[i] * a + b);
    vector[i] = clamp(value, min, max);
}
