package map

import application.model.observableVessel

fun clearMap(map: LeafletMapView) {
    clearMapCanvas(map)
    clearMapCluster(map)
    clearHeatMap(map)
    clearMarker(map)
}

fun clearMapCluster(map: LeafletMapView) {
    map.execScript(
        """
        |myMap.removeLayer(markerClusters);
        |var markerClusters = L.markerClusterGroup({spiderfyOnMaxZoom: false, disableClusteringAtZoom: 10});
    """.trimMargin()
    )
}

fun clearMapCanvas(map: LeafletMapView) {
    map.execScript(
        """
        |myRenderer.removeFrom(myMap);
        |var myRenderer = L.canvas({ padding: 0.5 });
    """.trimMargin()
    )
}

fun clearHeatMap(map: LeafletMapView) {
    map.execScript(
        """
        |heatLayer.removeFrom(myMap);
        |var heatLayer = L.heatLayer([]).addTo(myMap);
    """.trimMargin()
    )
}

fun clearMarker(map: LeafletMapView) {
    map.execScript(
        """
        |for(var i = 0; i < markers.length; i++){
            |myMap.removeLayer(markers[i]);
        |}
        |markers = []
    """.trimMargin()
    )
}

fun displayAllMessageOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            map.execScript("L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 0.01, color: '#${message.getHexColorStroke()}'}).addTo(myMap)")
        }
    }
}

fun displayTimedAllMessageOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 0.01, color: '#${message.getHexColorStroke()}'}).addTo(myMap))")
    }
}

fun displayAllMessageOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            if (selectedMMSI == message.mmsi.value) {
                map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 2, color: '#ff4040'}).addTo(myMap))")
            } else {
                map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 0.01, color: '#${message.getHexColorStroke()}'}).addTo(myMap))")
            }
        }
    }
}

fun displayTimedAllMessageOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        if (selectedMMSI == message.mmsi.value) {
            map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 2, color: '#ff4040'}).addTo(myMap))")
        } else {
            map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 0.01, color: '#${message.getHexColorStroke()}'}).addTo(myMap))")
        }
    }
}

fun displayClusterMessageOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            map.execScript("markerClusters.addLayer(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 0.01, color: '#${message.getHexColorStroke()}'}));")
        }
    }
    map.execScript("myMap.addLayer(markerClusters);")
}

fun displayTimedClusterMessageOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        map.execScript("markerClusters.addLayer(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 0.01, color: '#${message.getHexColorStroke()}'}));")
    }
    map.execScript("myMap.addLayer(markerClusters);")
}

fun displayClusterMessageOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            if (selectedMMSI == message.mmsi.value) {
                map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 2, color: '#ff4040'}).addTo(myMap));")
            } else {
                map.execScript("markerClusters.addLayer(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {renderer: myRenderer, radius: 0.01, color: '#${message.getHexColorStroke()}'}));")
            }
        }
    }
    map.execScript("myMap.addLayer(markerClusters);")
}

fun displayTimedClusterMessageOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        if (selectedMMSI == message.mmsi.value) {
            map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 2, color: '#ff4040'}).addTo(myMap));")
        } else {
            map.execScript("markerClusters.addLayer(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 0.01, color: '#${message.getHexColorStroke()}'}));")
        }
    }
    map.execScript("myMap.addLayer(markerClusters);")
}

fun displayHeatMapOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            map.execScript("heatLayer.addLatLng([${message.latitude.value}, ${message.longitude.value}]);")
        }
    }
}

fun displayTimedHeatMapOnMap(map: LeafletMapView) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        map.execScript("heatLayer.addLatLng([${message.latitude.value}, ${message.longitude.value}]);")
    }
}

fun displayHeatMapOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        value.messages.forEach { (_, message) ->
            if (selectedMMSI == message.mmsi.value) {
                map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 2, color: '#ff4040'}).addTo(myMap));")
            } else {
                map.execScript("heatLayer.addLatLng([${message.latitude.value}, ${message.longitude.value}]);")
            }
        }
    }
    map.execScript("myMap.addLayer(markerClusters);")
}

fun displayTimedHeatMapOnMap(map: LeafletMapView, selectedMMSI: String) {
    clearMap(map)
    observableVessel.vessels.forEach { (_, value) ->
        val message = value.messageToDisplay ?: return@forEach
        if (selectedMMSI == message.mmsi.value) {
            map.execScript("markers.push(L.circleMarker([${message.latitude.value}, ${message.longitude.value}], {radius: 2, color: '#ff4040'}).addTo(myMap));")
        } else {
            map.execScript("heatLayer.addLatLng([${message.latitude.value}, ${message.longitude.value}]);")
        }
    }
}