package application.model

import java.io.File
import java.time.ZoneOffset
import java.util.*

fun createVesselCollection(file: File): SortedMap<String, Vessel> {
    val messages: ArrayList<Message> = arrayListOf()
    val vessels: SortedMap<String, Vessel> = sortedMapOf()
    var maxTime: Long = 0
    var minTime: Long = Long.MAX_VALUE

    file.forEachLine {
        val arrayMessage = it.split(",")
        if (arrayMessage[0].toIntOrNull() !== null) {
            val message = Message(arrayMessage)
            messages.add(message)
            if (!vessels.containsKey(message.mmsi.value)) {
                vessels[message.mmsi.value] = Vessel(message.mmsi.value!!)
            }
            val time = message.time.date.toEpochSecond(ZoneOffset.UTC)
            vessels[message.mmsi.value]?.messages?.set(time, message)
            if (time > maxTime) {
                maxTime = time
            }
            if (time < minTime){
                minTime = time
            }
        }
    }

    Vessel.maxTime = maxTime
    Vessel.minTime = minTime

    return vessels
}
