package application.model

import kotlin.properties.Delegates

class ObservableSelectedVessel {
    val listeners: MutableList<SelectedVesselListener> = mutableListOf()

    var value: Vessel by Delegates.observable(
        initialValue = Vessel(null),
        onChange = { _, _, new ->
            run {
                listeners.forEach {
                    it.onValueChanged(new)
                }
            }
        }
    )
}