package application.model

import java.time.LocalDateTime

class Message(split: List<String>) {
    val mmsi = MMSI(if (split[0] == "") null else split[0])
    val time = Time(LocalDateTime.parse(split[1]))
    val latitude = Latitude(split[2].toDoubleOrNull())
    val longitude = Longitude(split[3].toDoubleOrNull())
    val speedOverGround = SpeedOverGround(split[4].toDoubleOrNull())
    val courseOverGround = CourseOverGround(split[5].toDoubleOrNull())
    val heading = Heading(split[6].toDoubleOrNull())
    val vesselName = VesselName(if (split[7] == "") null else split[7])
    val imo = IMO(if (split[8] == "") null else split[8])
    val callSign = CallSign(if (split[9] == "") null else split[9])
    val vesselType = VesselType(split[10].toDoubleOrNull())
    val status = Status(if (split[11] == "") null else split[11])
    val length = Length(split[12].toDoubleOrNull())
    val width = Width(split[13].toDoubleOrNull())
    val draft = Draft(split[14].toDoubleOrNull())
    val cargo = Cargo(split[15].toDoubleOrNull())

    fun getHexColorStroke(): String {
        var hex = Integer.toHexString(this.mmsi.value?.toInt()!!)
        if (hex.length > 6) {
            hex = hex.substring(hex.length - 6)
        }
        return hex
    }
}