package application.model

import kotlin.properties.Delegates

class ObservableVessel {
    val listeners: MutableList<MessageListener> = mutableListOf()

    var vessels: MutableMap<String?, Vessel> by Delegates.observable(
        initialValue = mutableMapOf(),
        onChange = { _, _, new ->
            run {
                observableSelectedVessel.value = Vessel(null)
                listeners.forEach {
                    it.onValueChanged(new)
                }
            }
        }
    )

}