package application.model

import kotlin.properties.Delegates

class ObservableCurrentTime {

    val listeners: MutableList<CurrentTime> = mutableListOf()

    var value: Int by Delegates.observable(
        initialValue = Int.MAX_VALUE,
        onChange = { _, _, new ->
            run {
                listeners.forEach {
                    it.onValueChanged(new)
                }
            }
        }
    )

}
