package application.model

import java.time.LocalDateTime

interface MessageDataVisitor {
    fun visit(messageData: MMSI)
    fun visit(messageData: Time)
    fun visit(messageData: Latitude)
    fun visit(messageData: Longitude)
    fun visit(messageData: SpeedOverGround)
    fun visit(messageData: CourseOverGround)
    fun visit(messageData: Heading)
    fun visit(messageData: VesselName)
    fun visit(messageData: IMO)
    fun visit(messageData: CallSign)
    fun visit(messageData: VesselType)
    fun visit(messageData: Status)
    fun visit(messageData: Length)
    fun visit(messageData: Width)
    fun visit(messageData: Draft)
    fun visit(messageData: Cargo)
}

interface MessageData {

    fun accept(visitor: MessageDataVisitor)

}

data class MMSI(val value: String?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Time(val date: LocalDateTime) : MessageData {
    val value: String?

    init {
        value = date.toString()
    }

    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Latitude(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Longitude(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class SpeedOverGround(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class CourseOverGround(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Heading(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class VesselName(val value: String?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class IMO(val value: String?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class CallSign(val value: String?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class VesselType(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Status(val value: String?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Length(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Width(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Draft(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

data class Cargo(val value: Double?) : MessageData {
    override fun accept(visitor: MessageDataVisitor) = visitor.visit(messageData = this)
}

class GetValueVisitor() : MessageDataVisitor {
    var value: String = ""

    override fun visit(messageData: MMSI) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Time) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Latitude) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Longitude) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: SpeedOverGround) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: CourseOverGround) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Heading) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: VesselName) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: IMO) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: CallSign) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: VesselType) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Status) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Length) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Width) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Draft) {
        value = messageData.value.toString()
    }

    override fun visit(messageData: Cargo) {
        value = messageData.value.toString()
    }

}


