@file:JvmName("App")

package application

import javafx.application.Application
import javafx.application.Platform
import javafx.event.EventHandler
import javafx.fxml.FXMLLoader
import javafx.scene.Parent
import javafx.scene.Scene
import javafx.stage.Stage
import jfxtras.styles.jmetro.JMetro
import jfxtras.styles.jmetro.Style
import kotlin.system.exitProcess


class App : Application() {
    var style: Style = Style.LIGHT

    override fun start(primaryStage: Stage?) {

        val fxmlLoader = FXMLLoader(App::class.java.getResource("/gui/windows.fxml"))
        val parent: Parent = fxmlLoader.load()
        val scene = Scene(parent)
        JMetro(scene, style)
        primaryStage!!.scene = scene
        primaryStage.title = "Maritime Visualisation"
        primaryStage.onCloseRequest = EventHandler { closeApplication() }
        primaryStage.show()
    }

    private fun closeApplication() {
        Platform.exit()
        exitProcess(0)
    }

    companion object {
        @JvmStatic
        fun main(args: Array<String>) {
            launch(App::class.java)
        }
    }

}