package application.controller

import application.model.MapState.*
import application.model.createVesselCollection
import application.model.observableIsReplayState
import application.model.observableMapState
import application.model.observableVessel
import javafx.event.EventHandler
import javafx.fxml.FXML
import javafx.fxml.Initializable
import javafx.scene.control.*
import javafx.stage.FileChooser
import java.io.*
import java.net.URL
import java.util.*


class MenuBarController : Initializable {

    @FXML
    var menuBar: MenuBar = MenuBar()

    @FXML
    var import: MenuItem = MenuItem()

    @FXML
    var allMessages: CheckMenuItem = CheckMenuItem()

    @FXML
    var clusteredMessage: CheckMenuItem = CheckMenuItem()

    @FXML
    var heatMap: CheckMenuItem = CheckMenuItem()

    @FXML
    var activateTimeSliderButton: RadioMenuItem = RadioMenuItem()

    override fun initialize(location: URL?, resources: ResourceBundle?) {

        setOnActionImportButton()

        setOnActionAllMessageButton()
        setOnActionClusteredMessageButton()
        setOnActionHeatMapButton()
        setOnActionActivateReplayButton()
        observableMapState.state = CLUSTERED_MESSAGES
        allMessages.isSelected = false
        clusteredMessage.isSelected = true
        heatMap.isSelected = false

    }

    private fun setOnActionActivateReplayButton() {
        activateTimeSliderButton.onAction = EventHandler {
            observableIsReplayState.value = activateTimeSliderButton.isSelected
        }
    }

    private fun setOnActionImportButton() {
        import.onAction = EventHandler {
            val fileChooser = FileChooser()
            fileChooser.title = "Choose a file to import"
            val window = menuBar.scene.window
            val file = fileChooser.showOpenDialog(window)

            try {
                if (file.extension != "csv") {
                    val alert = Alert(Alert.AlertType.WARNING)
                    alert.title = "Warning Alert"
                    alert.headerText = "Wrong file format."
                    alert.contentText = "Please choose à .csv file."
                    alert.showAndWait()
                }
                observableVessel.vessels.clear()
                if(toMuchVessel(file)){
                    observableVessel.vessels = mutableMapOf()
                }else {
                    val vessels = createVesselCollection(file)
                    observableVessel.vessels = vessels
                }
            } catch (ignore: IllegalStateException) {

            }
        }
    }

    private fun toMuchVessel(file: File): Boolean {
        val nbLine = file.readLines().size
        if (nbLine > 50000) {
            val alert = Alert(Alert.AlertType.CONFIRMATION)
            alert.title = "Warning!!"
            alert.headerText = "Warning: This file contain a lot of messages."
            alert.contentText = "Are you sure you want to continue."
            val buttonTypeYes = ButtonType("Yes")
            val buttonTypeNo = ButtonType("No ")
            alert.buttonTypes.setAll(buttonTypeYes, buttonTypeNo)
            val result = alert.showAndWait()

            return result.get() != buttonTypeYes
        }
        return false
    }

    private fun setOnActionAllMessageButton() {
        allMessages.onAction = EventHandler {
            observableMapState.state = ALL_MESSAGES
            allMessages.isSelected = true
            clusteredMessage.isSelected = false
            heatMap.isSelected = false
        }
    }

    private fun setOnActionClusteredMessageButton() {
        clusteredMessage.onAction = EventHandler {
            observableMapState.state = CLUSTERED_MESSAGES
            heatMap.isSelected = false
            allMessages.isSelected = false
            clusteredMessage.isSelected = true
        }
    }

    private fun setOnActionHeatMapButton() {
        heatMap.onAction = EventHandler {
            observableMapState.state = HEAT_MAP
            heatMap.isSelected = true
            clusteredMessage.isSelected = false
            allMessages.isSelected = false
        }
    }


}