package application.model

import java.util.*

class Vessel(val mmsi: String?) {
    val messages: SortedMap<Long, Message> = sortedMapOf()
    private val messageBeforeSelectedTime: Map<Long, Message>
        get() {
            return messages.filter { observableCurrentTime.value > it.key }
        }

    var messageToDisplay: Message? = null
        get() {
            field =
                messages.asSequence().map { it }.firstOrNull { observableCurrentTime.value < it.key }.let { it?.value }
            return field
        }

    fun getAllTimeBeforeSelectedTime(): ArrayList<String> {
        val timeList = arrayListOf<String>()
        messageBeforeSelectedTime.forEach {
            if (it.value.time.value != null)
                timeList.add(it.value.time.value!!)
        }

        return timeList
    }

    fun getAllLatitudeBeforeSelectedTime(): ArrayList<Double> {
        val latitudeList = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.latitude.value != null)
                latitudeList.add(it.value.latitude.value!!)
        }

        return latitudeList
    }

    fun getAllLongitudeBeforeSelectedTime(): ArrayList<Double> {
        val longitudeList = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.longitude.value != null)
                longitudeList.add(it.value.longitude.value!!)
        }

        return longitudeList
    }

    fun getAllSpeedOverGroundBeforeSelectedTime(): ArrayList<Double> {
        val speedOverGroundList = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.speedOverGround.value != null)
                speedOverGroundList.add(it.value.speedOverGround.value!!)
        }

        return speedOverGroundList
    }

    fun getAllCourseOverGroundBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.courseOverGround.value != null)
                res.add(it.value.courseOverGround.value!!)
        }

        return res
    }

    fun getAllHeadingBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.heading.value != null)
                res.add(it.value.heading.value!!)
        }

        return res
    }

    fun getAllVesselNameBeforeSelectedTime(): ArrayList<String> {
        val res = arrayListOf<String>()
        messageBeforeSelectedTime.forEach {
            if (it.value.vesselName.value != null)
                res.add(it.value.vesselName.value!!)
        }
        return res
    }

    fun getAllIMOBeforeSelectedTime(): ArrayList<String> {
        val res = arrayListOf<String>()
        messageBeforeSelectedTime.forEach {
            if (it.value.imo.value != null)
                res.add(it.value.imo.value!!)
        }
        return res
    }

    fun getAllCallSignBeforeSelectedTime(): ArrayList<String> {
        val res = arrayListOf<String>()
        messageBeforeSelectedTime.forEach {
            if (it.value.callSign.value != null)
                res.add(it.value.callSign.value!!)
        }
        return res
    }

    fun getAllVesselTypeBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.vesselType.value != null)
                res.add(it.value.vesselType.value!!)
        }
        return res
    }

    fun getAllStatusBeforeSelectedTime(): ArrayList<String> {
        val res = arrayListOf<String>()
        messageBeforeSelectedTime.forEach {
            if (it.value.status.value != null)
                res.add(it.value.status.value!!)
        }
        return res
    }

    fun getAllLengthBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.length.value != null)
                res.add(it.value.length.value!!)
        }
        return res
    }

    fun getAllWidthBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.width.value != null)
                res.add(it.value.width.value!!)
        }
        return res
    }

    fun getAllDraftBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.draft.value != null)
                res.add(it.value.draft.value!!)
        }
        return res
    }

    fun getAllCargoBeforeSelectedTime(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messageBeforeSelectedTime.forEach {
            if (it.value.cargo.value != null)
                res.add(it.value.cargo.value!!)
        }
        return res
    }

    fun getAllTime(): ArrayList<String> {
        val timeList = arrayListOf<String>()
        messages.forEach {
            if (it.value.time.value != null)
                timeList.add(it.value.time.value!!)
        }

        return timeList
    }

    fun getAllLatitude(): ArrayList<Double> {
        val latitudeList = arrayListOf<Double>()
        messages.forEach {
            if (it.value.latitude.value != null)
                latitudeList.add(it.value.latitude.value!!)
        }

        return latitudeList
    }

    fun getAllLongitude(): ArrayList<Double> {
        val longitudeList = arrayListOf<Double>()
        messages.forEach {
            if (it.value.longitude.value != null)
                longitudeList.add(it.value.longitude.value!!)
        }

        return longitudeList
    }

    fun getAllSpeedOverGround(): ArrayList<Double> {
        val speedOverGroundList = arrayListOf<Double>()
        messages.forEach {
            if (it.value.speedOverGround.value != null)
                speedOverGroundList.add(it.value.speedOverGround.value!!)
        }

        return speedOverGroundList
    }

    fun getAllCourseOverGround(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.courseOverGround.value != null)
                res.add(it.value.courseOverGround.value!!)
        }

        return res
    }

    fun getAllHeading(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.heading.value != null)
            res.add(it.value.heading.value!!)
        }

        return res
    }

    fun getAllVesselName(): ArrayList<String> {
        val res = arrayListOf<String>()
        messages.forEach {
            if (it.value.vesselName.value != null)
                res.add(it.value.vesselName.value!!)
        }
        return res
    }

    fun getAllIMO(): ArrayList<String> {
        val res = arrayListOf<String>()
        messages.forEach {
            if (it.value.imo.value != null)
                res.add(it.value.imo.value!!)
        }
        return res
    }

    fun getAllCallSign(): ArrayList<String> {
        val res = arrayListOf<String>()
        messages.forEach {
            if (it.value.callSign.value != null)
                res.add(it.value.callSign.value!!)
        }
        return res
    }

    fun getAllVesselType(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.vesselType.value != null)
                res.add(it.value.vesselType.value!!)
        }
        return res
    }

    fun getAllStatus(): ArrayList<String> {
        val res = arrayListOf<String>()
        messages.forEach {
            if (it.value.status.value != null)
                res.add(it.value.status.value!!)
        }
        return res
    }

    fun getAllLength(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.length.value != null)
                res.add(it.value.length.value!!)
        }
        return res
    }

    fun getAllWidth(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.width.value != null)
                res.add(it.value.width.value!!)
        }
        return res
    }

    fun getAllDraft(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.draft.value != null)
                res.add(it.value.draft.value!!)
        }
        return res
    }

    fun getAllCargo(): ArrayList<Double> {
        val res = arrayListOf<Double>()
        messages.forEach {
            if (it.value.cargo.value != null)
                res.add(it.value.cargo.value!!)

        }
        return res
    }

    companion object {
        var maxTime: Long = 0
        var minTime: Long = 0
    }

}