package application.model

import kotlin.properties.Delegates

class ObservableReplayState {

    val listeners: MutableList<ReplayState> = mutableListOf()

    var value: Boolean by Delegates.observable(
        initialValue = false,
        onChange = { _, _, new ->
            run {
                listeners.forEach {
                    it.onValueChanged(new)
                }
            }
        }
    )

}
