package application.model

import kotlin.properties.Delegates

class ObservableMapState {
    val listeners: MutableList<StateListener> = mutableListOf()

    var state: MapState by Delegates.observable(
        initialValue = MapState.CLUSTERED_MESSAGES,
        onChange = { _, _, new ->
            run {
                listeners.forEach {
                    it.onValueChanged(new)
                }
            }
        }
    )
}
